Attribute VB_Name = "modCommands"

Option Base 0
Option Explicit
Option Compare Binary

Private Declare Function GetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpString As Any, ByVal lpFileName As String) As Long

Public Masters() As tMasters
Public Type tMasters
    Bot As Object
    Trigger As String
    Masters() As String
End Type

Public Sub Initialize()
    ReDim Masters(0)
End Sub

Public Function IsInit(ByVal Index As Integer) As Boolean
    If Not Masters(Index).Bot Is Nothing Then IsInit = True
End Function

Private Function G(ByVal Profile As String, ByVal Key As String) As String
Dim Ret As String, i As Long
    Ret = String$(256, vbNullChar)
    i = InStrRev(App.Path, "\")
    Call GetPrivateProfileString(Profile, Key, vbNullString, Ret, 256, Left$(App.Path, i) & "Files\Config.ini")
    G = TrimString(Ret)
End Function

Private Sub W(ByVal Profile As String, ByVal Key As String, ByVal sText As String)
Dim i As Long
    i = InStrRev(App.Path, "\")
    Call WritePrivateProfileString(Profile, Key, sText, Left$(App.Path, i) & "Files\Config.ini")
End Sub

Public Sub LoadNewMasters(ByVal Bot As Object)
Dim NewMasters As String, i As Long
    i = InStrRev(App.Path, "\")
    NewMasters = G(Bot.Profile, "Masters")
    For i = 0 To UBound(Masters)
        If IsInit(i) = True Then
            If LCase$(Masters(i).Bot.Profile) = LCase$(Bot.Profile) Then
                If NewMasters <> vbNullString Then
                    NewMasters = Replace(NewMasters, Space$(1), vbNullString)
                    Masters(i).Masters = Split(NewMasters, ",")
                Else
                    ReDim Masters(i).Masters(0)
                End If
                Exit Sub
            End If
        End If
    Next i
    For i = 0 To UBound(Masters)
        If IsInit(i) = False Then
            Set Masters(i).Bot = Bot
            If NewMasters <> vbNullString Then
                NewMasters = Replace(NewMasters, Space$(1), vbNullString)
                Masters(i).Masters = Split(NewMasters, ",")
            Else
                ReDim Masters(i).Masters(0)
            End If
            Exit Sub
        End If
    Next i
    i = UBound(Masters) + 1
    ReDim Preserve Masters(i)
    Set Masters(i).Bot = Bot
    If NewMasters <> vbNullString Then
        NewMasters = Replace(NewMasters, Space$(1), vbNullString)
        Masters(i).Masters = Split(NewMasters, ",")
    Else
        ReDim Masters(i).Masters(0)
    End If
End Sub

Public Sub AddMaster(ByVal BotIndex As Integer, ByVal Username As String)
Dim i As Integer, MIndex As Integer, tStr As String, FreeIndex As Integer
    FreeIndex = -1
    MIndex = -1
    For i = 0 To UBound(Masters)
        If Masters(i).Bot.Index = BotIndex Then
            MIndex = i
            Exit For
        End If
    Next i
    If MIndex = -1 Then Exit Sub
    For i = 0 To UBound(Masters(MIndex).Masters)
        If LCase$(Masters(MIndex).Masters(i)) = LCase$(Username) Then
            Masters(MIndex).Bot.AddChat vbRed, "[Commands] " & Username & " already is a master!"
            Exit Sub
        ElseIf Masters(MIndex).Masters(i) = vbNullString Then
            FreeIndex = i
        End If
    Next i
    If FreeIndex > -1 Then
        i = FreeIndex
    Else
        i = UBound(Masters(MIndex).Masters) + 1
        ReDim Preserve Masters(MIndex).Masters(i)
    End If
    Masters(MIndex).Masters(i) = Username
    For i = 0 To UBound(Masters(MIndex).Masters)
        If Masters(MIndex).Masters(i) <> vbNullString Then
            tStr = tStr & Masters(MIndex).Masters(i) & ","
        End If
    Next i
    Call W(Masters(MIndex).Bot.Profile, "Masters", Left$(tStr, Len(tStr) - 1))
    Masters(MIndex).Bot.AddChat vbGreen, "[Commands] " & Username & " has been added as a master!"
End Sub

Public Sub RemMaster(ByVal BotIndex As Integer, ByVal Username As String)
Dim i As Integer, MIndex As Integer, Found As Boolean, tStr As String
    For i = 0 To UBound(Masters)
        If Masters(i).Bot.Index = BotIndex Then
            MIndex = i
            Exit For
        End If
    Next i
    For i = 0 To UBound(Masters(MIndex).Masters)
        If LCase$(Masters(MIndex).Masters(i)) = LCase$(Username) Then
            Masters(MIndex).Masters(i) = vbNullString
            Found = True
            Exit For
        End If
    Next i
    If Found = True Then
        For i = 0 To UBound(Masters(MIndex).Masters)
            If Masters(MIndex).Masters(i) <> vbNullString Then
                tStr = tStr & Masters(MIndex).Masters(i) & ","
            End If
        Next i
        Call W(Masters(MIndex).Bot.Profile, "Masters", Left$(tStr, Len(tStr) - 1))
        Masters(MIndex).Bot.AddChat vbGreen, "[Commands] " & Username & " has been removed from master list!"
    Else
        Masters(MIndex).Bot.AddChat vbRed, "[Commands] " & Username & " was not found in the master list!"
    End If
End Sub

Public Function IsMaster(ByVal Index As Integer, ByVal Username As String) As Boolean
Dim i As Integer
    For i = 0 To UBound(Masters(Index).Masters)
        If LCase$(Masters(Index).Masters(i)) = LCase$(Username) Then
            IsMaster = True
            Exit Function
        End If
    Next i
End Function

Public Function GetMasterIndex(ByVal Index As Integer) As Integer
Dim i As Integer
    GetMasterIndex = -1
    For i = 0 To UBound(Masters)
        If Masters(i).Bot.Index = Index Then
            GetMasterIndex = i
            Exit Function
        End If
    Next i
End Function

Public Function Commands(ByVal Index As Integer, ByVal Username As String, ByVal Message As String) As Boolean
Dim i As Long, splt() As String
    Index = GetMasterIndex(Index)
    If Index = -1 Then Exit Function
    i = Len(Masters(Index).Trigger)
    If Left$(Message, i) <> Masters(Index).Trigger Then Exit Function
    Message = Mid$(Message, i + 1)
    If (Message <> vbNullString) And (IsMaster(Index, Username) = True) Then
        splt = Split(Message, Space$(1), 2)
        
        ' All Commands / Functions go below, in case you wish to add your own.
        
        Select Case LCase$(splt(0))
        
            Case "trigger"
                If UBound(splt) = 1 Then
                    Masters(Index).Trigger = splt(1)
                    W Masters(Index).Bot.Profile, "Trigger", splt(1)
                    Exit Function
                Else
                    If Masters(Index).Trigger = vbNullString Then
                        Masters(Index).Bot.Send "No current trigger is specified!"
                    Else
                        Masters(Index).Bot.Send "Current trigger: " & Masters(Index).Trigger
                    End If
                    Exit Function
                End If
                
            Case "s", "say"
                If UBound(splt) = 1 Then
                    Masters(Index).Bot.Send splt(1)
                    Exit Function
                End If
        
            Case "j", "join"
                If UBound(splt) = 1 Then
                    Masters(Index).Bot.Send "/j " & splt(1)
                    Exit Function
                End If
                
            Case "home", "homechannel", "gohome"
                If UBound(splt) = 1 Then
                    Masters(Index).Bot.Send "/j " & Masters(Index).Bot.HomeChannel
                    Exit Function
                End If
                
        End Select
        
    End If
End Function
